/*
 * PropertyListImplHelper.java
 *
 * Created on April 1, 2003, 10:52 AM
 * 
 * Copyright 2003 Danny Brewer
 * Anyone may run this code.
 * If you wish to modify or distribute this code, then
 *  you are granted a license to do so only under the terms
 *  of the Gnu Lesser General Public License.
 * See:  http://www.gnu.org/licenses/lgpl.html
 */

package nom.DannyBrewer.utils;

/**
 *
 * @author  danny brewer
 */
public abstract class PropertyListImplHelper
		implements PropertyList
{
	
	public PropertyListImplHelper() { }
	
	
    //----------------------------------------------------------------------
    //  PropertyList interface
	//	The following are just wrappers for the typecasting utilities
	//	 in PropertyListUtils.
    //----------------------------------------------------------------------
	
	public int getIntProperty( String propName ) {
		return PropertyListUtils.getIntProperty( this, propName );
	}
	
	public int getIntProperty( String propName, int defaultValue ) {
		return PropertyListUtils.getIntProperty( this, propName, defaultValue );
	}
	
	public void setIntProperty( String propName, int value ) {
		PropertyListUtils.setIntProperty( this, propName, value );
	}
	
	
	
	public long getLongProperty( String propName ) {
		return PropertyListUtils.getLongProperty( this, propName );
	}
	
	public long getLongProperty( String propName, long defaultValue ) {
		return PropertyListUtils.getLongProperty( this, propName, defaultValue );
	}
	
	public void setLongProperty( String propName, long value ) {
		PropertyListUtils.setLongProperty( this, propName, value );
	}


	
	public String getStringProperty( String propName ) {
		return PropertyListUtils.getStringProperty( this, propName );
	}

	public String getStringProperty( String propName, String defaultValue ) {
		return PropertyListUtils.getStringProperty( this, propName, defaultValue );
	}

	public void setStringProperty( String propName, String value ) {
		PropertyListUtils.setStringProperty( this, propName, value );
	}

	
	
	public boolean getBooleanProperty( String propName ) {
		return PropertyListUtils.getBooleanProperty( this, propName );
	}

	public boolean getBooleanProperty( String propName, boolean defaultValue ) {
		return PropertyListUtils.getBooleanProperty( this, propName, defaultValue );
	}

	public void setBooleanProperty( String propName, boolean value ) {
		PropertyListUtils.setBooleanProperty( this, propName, value );
	}

	
	
	public float getFloatProperty( String propName ) {
		return PropertyListUtils.getFloatProperty( this, propName );
	}

	public float getFloatProperty( String propName, float defaultValue ) {
		return PropertyListUtils.getFloatProperty( this, propName, defaultValue );
	}

	public void setFloatProperty( String propName, float value ) {
		PropertyListUtils.setFloatProperty( this, propName, value );
	}

	
	
	public double getDoubleProperty( String propName ) {
		return PropertyListUtils.getDoubleProperty( this, propName );
	}

	public double getDoubleProperty( String propName, double defaultValue ) {
		return PropertyListUtils.getDoubleProperty( this, propName, defaultValue );
	}

	public void setDoubleProperty( String propName, double value ) {
		PropertyListUtils.setDoubleProperty( this, propName, value );
	}

}
